package zigen.plugin.db.ext.s2jdbc.wizards;

public class FormProperty {
	
	public static final int MODIFIED_PUBLIC = 0;
	
	public static final int MODIFIED_DEFAULT = 1;
	
	public static final int MODIFIED_PRIVATE = 2;
	
	public static final int MODIFIED_PROTECTED = 3;
	
	public static final String[] COMBO_ITEM = new String[] {"public", "default", "private", "protected"};
	
	
	public int no;
	
	public String name;
	
	// public String modified;
	public int modified = MODIFIED_PUBLIC;
	
	
	public String type;
	
	public boolean isRequired;
	
	public void setValue(int index, String value) {
		switch (index) {
			case 0:
				return;
				
			case 1:
				no = new Integer(value).intValue();
				return;
			case 2:
				name = value.trim();
				return;
			case 3:
				type = value.trim();
				return;
				
			case 4:
				// modified = value;
				if (value != null && !"".equals(value) && !"null".equals(value)) {
					modified = new Integer(value).intValue();
				}
				return;
				
			case 5:
				isRequired = new Boolean(value).booleanValue();
				return;
				
		}
		throw new IllegalArgumentException("CfbNX̎wɌ肪܂");
	}
	
	public Object getValue(int index) {
		switch (index) {
			case 0:
				return null;
			case 1:
				return no;
			case 2:
				return name;
			case 3:
				return type;
			case 4:
				return modified;
			case 5:
				return isRequired;
				
		}
		throw new IllegalArgumentException("CfbNX̎wɌ肪܂");
	}
	
	public String getModifiedString() {
		if (modified == FormProperty.MODIFIED_DEFAULT) {
			return "";
		} else {
			return FormProperty.COMBO_ITEM[modified];
		}
		
	}
}
